#include "driver.h"



static int firstchannel,numchannels;

#define MAX_CHANNELS 8
#define MAX_SAMPLES_PER_FRAME 1600
#define FACTOR 1
#define DEBUG 0

struct PlayingSAM {
        int     bytes_played;           /* Bytes already played */
        int     max_frame_len;          /* Max Frame length*/
        int     current_frame_len;      /* Current Frame length*/
        int     loop;                   /* loop 1 yes, 0 no */
        int     active;                 /* 1 active, 0 inactive */
	int	sample_length;		/* Sample: length */
	int	sample_freq;		/* Sample: frequency */
	char	sample_res;		/* Sample: resolution (8 or 16) */
	char	sample_volume;		/* Sample: volume */
	signed char	*sample_data;	/* Sample: data (pointer to) */
};

static struct PlayingSAM disksample[MAX_CHANNELS];

/* Start one of the samples loaded from disk. Note: channel must be in the range */
/* 0 .. Samplesinterface->channels-1. It is NOT the discrete channel to pass to */
/* osd_play_sample() */
void sample_start(int channel,int samplenum,int loop)
{
	int iSampleResAdj;

	if (Machine->sample_rate == 0) return;
	if (Machine->samples == 0) return;
	if (Machine->samples->sample[samplenum] == 0) return;
	if (samplenum >= Machine->samples->total)
	{
		return;
	}

	/*
	 * 	Attempt to play all samples
	 * 	Wrap around the channel number if it exceeds MAX_CHANNELS
	 *	This may cause overlap with some channels trying to play on top
	 *	of each other but also means that more samples should play.
	 */
	channel %= MAX_CHANNELS;

	/*
	 * Currently playing on this channel already?
	 */
/*
	if (disksample[channel].active)
	{
		sample_stop(channel);
	}
*/

	/*
	 * Setup sample structure
	 */
	disksample[channel].sample_length = Machine->samples->sample[samplenum]->length;
	disksample[channel].sample_freq = Machine->samples->sample[samplenum]->smpfreq;
	disksample[channel].sample_res = Machine->samples->sample[samplenum]->resolution;
	disksample[channel].sample_volume = Machine->samples->sample[samplenum]->volume;
	disksample[channel].sample_data = Machine->samples->sample[samplenum]->data;
	iSampleResAdj = disksample[channel].sample_res == 8 ? 0:1;
	disksample[channel].max_frame_len = (disksample[channel].sample_freq << iSampleResAdj) / Machine->drv->frames_per_second;
	if (disksample[channel].max_frame_len > MAX_SAMPLES_PER_FRAME) disksample[channel].max_frame_len = MAX_SAMPLES_PER_FRAME;
	disksample[channel].active = 1;
	disksample[channel].loop = loop;
	disksample[channel].bytes_played = 0;

#if 0
	/*
	 * Start playing...
	 * ... and finish playing in samples_sh_update()
	 */
	if ( disksample[channel].sample_res == 8 )
	{
		osd_play_sample(
			channel + firstchannel,
			disksample[channel].sample_data + disksample[channel].bytes_played,
			disksample[channel].current_frame_len,
			disksample[channel].sample_freq,
			disksample[channel].sample_volume,
			disksample[channel].loop);
	}
	else
	{
		osd_play_sample_16(
			channel + firstchannel,
			disksample[channel].sample_data + disksample[channel].bytes_played,
			disksample[channel].current_frame_len,
			disksample[channel].sample_freq,
			disksample[channel].sample_volume,
			disksample[channel].loop);
	}

	/*
	 * Update amount played
	 */
	disksample[channel].bytes_played += disksample[channel].current_frame_len;

	if (disksample[channel].bytes_played >= disksample[channel].sample_length)
	{
		if (disksample[channel].loop)
		{
			/* if looping, start again when played through */
			disksample[channel].bytes_played = 0;
		}
		else
		{
			/* if not, stop the sample */
			sample_stop(channel);
		}
	}
#endif
}

/* 
 * New function: used to setup a sample to play which was otherwise called just using osd_play_sample()
 */
void sample_setup(int channel, signed char *data, int length, int freq, int volume, int loop)
{
	int iSampleResAdj;

        if (Machine->sample_rate == 0) return;
        if (Machine->samples == 0) return;
	channel %= MAX_CHANNELS;

	disksample[channel].sample_length = length;
	disksample[channel].sample_freq = freq;
	disksample[channel].sample_res = 8;
	disksample[channel].sample_volume = volume;
	disksample[channel].sample_data = data;

	iSampleResAdj = disksample[channel].sample_res == 8 ? 0:1;
	disksample[channel].max_frame_len = (disksample[channel].sample_freq << iSampleResAdj) / Machine->drv->frames_per_second;
	if (disksample[channel].max_frame_len > MAX_SAMPLES_PER_FRAME) disksample[channel].max_frame_len = MAX_SAMPLES_PER_FRAME;
	disksample[channel].active = 1;
	disksample[channel].loop = loop;
	disksample[channel].bytes_played = 0;
}

void sample_adjust(int channel,int freq,int volume)
{
	int iSampleResAdj;

	if (Machine->sample_rate == 0) return;
	if (Machine->samples == 0) return;
	channel %= MAX_CHANNELS;


	/*
	 * Update sample structure
	 */
	if (disksample[channel].active == 1)
	{
		iSampleResAdj = disksample[channel].sample_res == 8 ? 0:1;
		disksample[channel].sample_volume = volume;
		disksample[channel].sample_freq = freq;

		/*
		 * This is the max length of sample to be played in one frame
		 * Equal to the sample's frequency divided by the machine's
		 * number of frames per sound.
		 * This is multiplied by 2 for 16-bit samples.
		 */
		/* disksample[channel].max_frame_len = ((disksample[channel].sample_freq * (disksample[channel].sample_freq / DEV_PLAY_FREQ )) << iSampleResAdj) / Machine->drv->frames_per_second;*/
		disksample[channel].max_frame_len = (disksample[channel].sample_freq << iSampleResAdj) / Machine->drv->frames_per_second;
		if (disksample[channel].max_frame_len > MAX_SAMPLES_PER_FRAME) disksample[channel].max_frame_len = MAX_SAMPLES_PER_FRAME;
	}

	osd_adjust_sample(channel + firstchannel,freq,volume);
}

void sample_stop(int channel)
{
	if (Machine->sample_rate == 0) return;

	channel %= MAX_CHANNELS;

	osd_stop_sample(channel + firstchannel);

	/*
	 * Update sample structure
	 */
	disksample[channel].active = 0;
}

int sample_playing(int channel)
{
	if (Machine->sample_rate == 0) return 0;
	channel %= MAX_CHANNELS;

	/* return !osd_get_sample_status(channel + firstchannel); */
	return disksample[channel].active;
}


int samples_sh_start(struct Samplesinterface *interface)
{
	int i;
	numchannels = interface->channels;
	firstchannel = get_play_channels(numchannels);
	return 0;
}

void samples_sh_stop(void)
{
	int i;

	for (i=0; i<MAX_CHANNELS; i++)
	{
		sample_stop(i);
		disksample[i].active = 0;
	}
}


void samples_sh_update(void)
{
	int i;
	int debug_count = 0;
/*
unsigned int frame_t = 0, prevframe_t = 0, time;
float percent_not_played;

	frame_t=GpTickCountGet();
	time=frame_t-prevframe_t;
	percent_not_played=1.0 - ((float)time/1000) / (1/(float)(Machine->drv->frames_per_second * FACTOR));
	if (percent_not_played > 1.0) percent_not_played = 1.0;
	if (percent_not_played < 0.0) percent_not_played = 0.0;
	prevframe_t=frame_t;
*/
	for (i=0; i<MAX_CHANNELS; i++)
	{
		if (disksample[i].active)
		{
			debug_count++;

			/* Assume frame length is the remaining data. */
			disksample[i].current_frame_len = disksample[i].sample_length - disksample[i].bytes_played;
			/* Adjust length if too large/small */
			if (disksample[i].current_frame_len > disksample[i].max_frame_len)
			{
				disksample[i].current_frame_len = disksample[i].max_frame_len;
			}
			if (disksample[i].current_frame_len < 0)
			{
				disksample[i].current_frame_len = 0;
			}

			if ( disksample[i].sample_res == 8 )
			{
				osd_play_sample(
					i + firstchannel,
					disksample[i].sample_data + disksample[i].bytes_played,
					disksample[i].current_frame_len,
					disksample[i].sample_freq,
					disksample[i].sample_volume,
					disksample[i].loop);
			}
			else
			{
				osd_play_sample_16(
					i + firstchannel,
					disksample[i].sample_data + disksample[i].bytes_played,
					disksample[i].current_frame_len,
					disksample[i].sample_freq,
					disksample[i].sample_volume,
					disksample[i].loop);
			}

#if DEBUG
			if (debug_count==1)
			{
				GpRectFill( NULL, &gpDraw[nflip],280,103,40,9,0x0 );
				gp32_text_out_int(280,100,i);
				GpRectFill( NULL, &gpDraw[nflip],280,113,40,9,0x0 );
				gp32_text_out_int(280,110,disksample[i].current_frame_len);
				GpRectFill( NULL, &gpDraw[nflip],280,123,40,9,0x0 );
				gp32_text_out_int(280,120,disksample[i].bytes_played);
				GpRectFill( NULL, &gpDraw[nflip],280,133,40,9,0x0 );
				gp32_text_out_int(280,130,disksample[i].sample_length);
			}
			if (debug_count==2)
			{
				GpRectFill( NULL, &gpDraw[nflip],280,153,40,9,0x0 );
				gp32_text_out_int(280,150,i);
				GpRectFill( NULL, &gpDraw[nflip],280,163,40,9,0x0 );
				gp32_text_out_int(280,160,disksample[i].current_frame_len);
				GpRectFill( NULL, &gpDraw[nflip],280,173,40,9,0x0 );
				gp32_text_out_int(280,170,disksample[i].bytes_played);
				GpRectFill( NULL, &gpDraw[nflip],280,183,40,9,0x0 );
				gp32_text_out_int(280,180,disksample[i].sample_length);
			}
#endif

			disksample[i].bytes_played += disksample[i].current_frame_len;

			if (disksample[i].bytes_played >= disksample[i].sample_length)
			{
				if (disksample[i].loop)
				{
					/* start again if played through */
					disksample[i].bytes_played = 0;
				}
				else
				{
					/* stop the sample */
					sample_stop(i);
				}
			}
		}
	}
#if DEBUG
	GpRectFill( NULL, &gpDraw[nflip],296,93,40,9,0x0 );
	gp32_text_out_int(296,90,debug_count);
#endif
}
